//
//  ESCTable.h
//  PrintDemo
//
//  Created by Mac on 5/31/21.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface ESCTable : NSObject

/**
 * 表格类初始化
 * 传入参数说明
 * column：表格标题头
 * regularExpression：上面column每个标题头的切割符号
 * columnWidthArray：每个标题头（每列）所占的字节数，1个英文符号一个字节，一个中文两个字节。58mm打印机，一行可以打印32个字节
 * columnWidthLength：有多少列
 */
/**
 * Table class initialization
 * Incoming parameter description
 * column: header of table title
 * regularExpression: the cutting symbol of each heading of the column above
 * columnWidthArray: The number of bytes occupied by each header (each column), one English symbol is one byte, and one Chinese is two bytes. 58mm printer, one line can print 32 bytes
 * columnWidthLength: how many columns
 */
-(instancetype)init:(NSString*)column regularExpression:(NSString*)regularExpression columnWidthArray:(int*)array columnWidthLength:(int)length;

/**
 * 设置每一列文字都靠右
 * 传入参数说明
 * 是否靠右
 */
/**
 * Set each column of text to the right
 * Incoming parameter description
 * Whether to right
 */
-(void)setColumnAlignRight:(BOOL)right;

/**
 * 添加一行打印的内容
 * Add a line of printed content
 */
-(void)addRow:(NSString*)row;

/**
 * 获取表格生成的文本内容
 * Get the text content generated by the table
 */
-(NSString*)getTableText;

@end

NS_ASSUME_NONNULL_END
